<?php
echo 'START<br>';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$activePage = 'bongapoints';

require_once '../config/config.php';
require_once '../auth/auth.php';
requireLogin();
require_once '../includes/header.php';
require_once '../includes/sidebar.php';

// Check database connection
if (!isset($pdo) || !$pdo) {
    die('Database connection failed');
}

try {
    // Get bonga points data
    $query = "SELECT 
        c.id,
        c.name,
        c.phone,
        COALESCE(SUM(s.total_amount), 0) as total_spent,
        FLOOR(COALESCE(SUM(s.total_amount), 0) / 100) as points
    FROM customers c
    LEFT JOIN sales s ON c.id = s.customer_id
    GROUP BY c.id, c.name, c.phone
    ORDER BY points DESC";

    $stmt = $pdo->prepare($query);
    $stmt->execute();
    $bongaPoints = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Query failed: " . $e->getMessage());
}
?>

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Bonga Points</h1>
                </div>
            </div>
        </div>
    </div>

    <section class="content">
        <div class="container-fluid">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Customer Points Summary</h3>
                </div>
                <div class="card-body">
                    <table class="table table-bordered table-striped" id="bongaTable">
                        <thead>
                            <tr>
                                <th>Customer Name</th>
                                <th>Phone</th>
                                <th>Total Spent (KES)</th>
                                <th>Points Earned</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($bongaPoints)): ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted">No customers with Bonga Points found.</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($bongaPoints as $customer): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($customer['name']) ?></td>
                                        <td><?= htmlspecialchars($customer['phone']) ?></td>
                                        <td><?= number_format($customer['total_spent'], 2) ?></td>
                                        <td><?= number_format($customer['points']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    $('#bongaTable').DataTable({
        "responsive": true,
        "lengthChange": true,
        "autoWidth": false,
        "order": [[3, "desc"]]
    });
});
</script>

<?php
require_once '../includes/footer.php';
?>
